package gov.va.med.mhv.integration.phr.transfer;

import java.io.Serializable;

/**
 * User: Rob Murtha
 */
public class Extract implements Serializable {
    private long id;
    private String name;
    private long enabled;
    private static final long serialVersionUID = -6258575222386823554L;

    public Extract(long id, String name, long enabled) {
        this.id = id;
        this.name=name;
        this.enabled=enabled;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return enabled==1;
    }

    public long getEnabled() {
        return this.enabled;
    }
    
    public void setEnabled(long enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Extract)) return false;

        Extract extract = (Extract) o;

        if (enabled != extract.enabled) return false;
        if (id != extract.id) return false;
        if (name != null ? !name.equals(extract.name) : extract.name != null) return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (int) (id ^ (id >>> 32));
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (int) (enabled ^ (enabled >>> 32));
        return result;
    }

    public String toString() {
        return "Extract{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", enabled=" + enabled +
                '}';
    }
    
}
